<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\BaseModel;
use App\Models\User;

class Report extends BaseModel
{
    use SoftDeletes;

    protected $table = 'reports';

    protected $fillable = ['user_id', 'history_id','tool_type','reason','more_detail'];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }



}
